package cn.com.duiba.live.normal.service.api.param.oto.product;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 产品表
 * @author kjj mybatis generator 
 * @date 2022-03-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ProductSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16484688807307514L;

    /**
     * 主键
     */
    private Long id;


    /**
     * 主键id
     */
    private List<Long> idList;

    /**
     * 产品名称
     */
    private String prodName;


    /**
     * 公司ids
     */
    private List<Long> companyIds;

    /**
     * 缴费周期
     */
    private String costOption;

    /**
     * 金额
     */
    private String moneyOption;

    /**
     * 是否上架是否状态 0:否 1:是
     */
    private Integer prodStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /** 供应商id */
    private Long supplierId;

    /** 允许查询的业务类型 */
    private List<Integer> allowBusinessTypes;
}