package cn.com.duiba.live.normal.service.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.company.LiveCompanyTeamNameDto;
import cn.com.duiba.live.normal.service.api.param.company.LiveTeamEsSearchParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

/**
 * 公司团队es相关服务
 *
 * @author xuzhigang
 * @date 2020/8/26 5:19 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveCompanyTeamEsApiService {

    /**
     * 异步保存或更新公司团队信息
     *
     * @param teamIds 公司团队id集合
     * @return 是否提交异步任务成功
     */
    boolean asyncInsertOrUpdate(List<Long> teamIds);

    /**
     * 根据团队id批量删除内容
     *
     * @param teamIds 公司id集合
     */
    void delete(List<Long> teamIds);

    /**
     * 根据公司id和团队名称获取团队信息，最多返回200条
     *
     * @param teamName 团队名称
     * @param companyId 公司id
     * @return 团队名称
     */
    List<LiveCompanyTeamNameDto> findByCompanyIdAndTeamName(Long companyId, String teamName);

    /**
     * 根据公司id和团队名称集合批量查询团队信息
     *
     * @param companyId 公司id
     * @param teamNames 团队名称集合
     * @return 团队信息
     */
    List<LiveCompanyTeamNameDto> findByCompanyIdAndTeamNames(Long companyId, List<String> teamNames);

    /**
     * 从es中查询团队列表
     * @return es查询结果
     */
    Pair<Long, List<LiveCompanyTeamNameDto>> searchTeamFromEs(LiveTeamEsSearchParam param);
}
