package cn.com.duiba.live.normal.service.api.remoteservice.oto.leads;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-02-16 09:45
 */
@AdvancedFeignClient
public interface RemoteCustCollectionApiService {

    /**
     * 批量放入回收池/垃圾池
     * @param custIds 客户id
     * @param recycleFlag 是否回收 是则放入回收池，否放入垃圾池
     * @return 回收结果
     */
    @Deprecated
    boolean batchPutRecGarPool(List<Long> custIds, boolean recycleFlag);

    /**
     * 批量放入回收池/垃圾池（区分场景）
     * @param custIds 客户id
     * @param recycleFlag 是否回收 是则放入回收池，否放入垃圾池
     * @param logScene 日志场景 {@link cn.com.duiba.live.normal.service.api.enums.oto.log.CustValueLogSceneEnum}
     * @return 回收结果
     */
    boolean batchPutRecGarPoolWithScene(List<Long> custIds, boolean recycleFlag,Integer logScene);
}
