package cn.com.duiba.live.normal.service.api.remoteservice.oto.link.mapping;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.link.mapping.LinkMappingDto;
import cn.com.duiba.live.normal.service.api.dto.oto.link.mapping.LinkMappingLinkInfoDTO;
import cn.com.duiba.live.normal.service.api.param.oto.link.mapping.LinkMappingSearchParam;

import java.util.List;

/**
 * 描述：
 *
 * @author zhouziwu
 * @date 2022-06-23
 */
@AdvancedFeignClient
public interface RemoteOtoLinkMappingService {

    /**
     * 按条件查询数量
     * @param param 条件
     * @return 小程序投放链接映射数量
     */
    Long selectCount(LinkMappingSearchParam param);

    /**
     * 按条件查询信息
     * @param param 条件
     * @return 小程序投放链接映射信息
     */
    List<LinkMappingDto> selectList(LinkMappingSearchParam param);

    /**
     * 保存小程序投放链接映射信息
     * @param param 保存信息
     * @return 是否成功
     */
    Boolean save(LinkMappingDto param);

    /**
     * 根据pathKey查询真实的投放链接信息
     * @param pathKey 映射key
     * @return 投放链接信息
     */
    LinkMappingLinkInfoDTO getTrueLinkInfo(Long pathKey);
}
