package cn.com.duiba.live.normal.service.api.remoteservice.oto.seller;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.seller.InterviewSceneConfDto;
import cn.com.duiba.live.normal.service.api.param.oto.seller.InterviewSceneConfSearchParam;

import java.util.List;

/**
 * @Author meichang
 * @Date 2022/5/18 13:50
 * @Version 1.0
 */
@AdvancedFeignClient
public interface RemoteOtoSceneConfService {

    /**
     * 新增、编辑面试场景配置
     * @param interviewSceneConfDto
     * @return 是否成功
     */
    Boolean saveOrUpdateInterviewSceneConf(InterviewSceneConfDto interviewSceneConfDto);

    /**
     * 根据id修改场景配置状态--启用/禁用
     */
    Boolean updateSceneConfStatusById(InterviewSceneConfDto interviewSceneConfDto);

    /**
     * 根据id删除场景配置
     * @param id
     * @return
     */
    Boolean deleteSceneConfStatusById(Long id);

    /**
     * 根据id查询场景配置
     */
    InterviewSceneConfDto getInterviewSceneConfById(Long id);

    /**
     * 分页查询场景配置
     */
    List<InterviewSceneConfDto> listSceneConf(InterviewSceneConfSearchParam param);

    /**
     * 查询场景配置总数
     * @return
     */
    Long listSceneConfCount();

    /**
     * 根据公司id和客户阶段查询场景配置
     * @param companyIds 产品组ID
     * @param custFlow 客户阶段流程组
     * @return
     */
    List<InterviewSceneConfDto> listSceneConfByCompanyId(List<Long> companyIds,Integer custFlow);

    /**
     * 校验场景配置状态
     * @param interviewConfId
     * @throws BizException
     */
    void checkSceneConfStatus(Long interviewConfId) throws BizException;

}
