package cn.com.duiba.live.normal.service.api.dto.live;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户预约表
 * @author kjj mybatis generator 
 * @date 2020-04-05
 */
@Data
public class LiveUserAppointmentDto implements Serializable {
     
    private static final long serialVersionUID = 15860583566042990L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务ID
     */
    private Long bizId;

    /**
     * 直播userId
     */
    private Long liveUserId;

    /**
     * 业务类型，1、直播间ID，2直播间奖励配置ID
     * @see cn.com.duiba.live.normal.service.api.enums.live.UserAppointmentBizTypeEnum
     */
    private Integer bizType;

    /**
     * 预约标识
     * @see cn.com.duiba.live.normal.service.api.enums.live.UserAppointmentFlagEnum
     */
    private Integer appointmentFlag;

    /**
     * 预约时间
     */
    private Date appointmentTime;

    /**
     * 被邀请的访客是否到场 0:未到场 1:到场
     */
    private Integer present;

}