package cn.com.duiba.live.normal.service.api.remoteservice.common;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.common.LiveCommonRedReceiveDto;

import java.util.List;

/**
 * 直播公共红包领取记录表
 * @author kjj mybatis generator 
 * @date 2021-01-29
 */
@AdvancedFeignClient
public interface RemoteLiveCommonRedReceiveService {

    /**
     * 根据业务类型和订单号查询
     * @param bizType 业务类型
     * @param bizTradeNo 订单号
     * @return 直播公共红包领取记录
     */
    LiveCommonRedReceiveDto selectByBizAndNo(Integer bizType, String bizTradeNo);

    /**
     * 新增
     * @param dto 直播公共红包领取记录
     * @return 执行结果
     */
    int insert(LiveCommonRedReceiveDto dto);

    /**
     * 更新
     * @param dto 直播公共红包领取记录
     * @return 执行结果
     */
    int update(LiveCommonRedReceiveDto dto);


    /**
     * 根据业务类型和订单号查询列表
     * @param bizType 业务类型
     * @param bizTradeNos 订单号
     * @return 直播公共红包领取记录
     */
    List<LiveCommonRedReceiveDto> selectByBizAndNos(Integer bizType, List<String> bizTradeNos);

}