/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LotteryCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(LotteryCodeUtil.class);
    private static final Character[] PLACEHOLDERS = new Character[]{Character.valueOf('M'), Character.valueOf('F'), Character.valueOf('T'), Character.valueOf('A'), Character.valueOf('S'), Character.valueOf('X'), Character.valueOf('D'), Character.valueOf('P'), Character.valueOf('C'), Character.valueOf('I'), Character.valueOf('Y'), Character.valueOf('V'), Character.valueOf('N'), Character.valueOf('L'), Character.valueOf('J'), Character.valueOf('Q'), Character.valueOf('E'), Character.valueOf('U'), Character.valueOf('Z'), Character.valueOf('K'), Character.valueOf('R'), Character.valueOf('B'), Character.valueOf('H'), Character.valueOf('O'), Character.valueOf('W'), Character.valueOf('G')};
    private static final Character[] PLACEHOLDERS2 = new Character[]{Character.valueOf('K'), Character.valueOf('Q'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('F'), Character.valueOf('T'), Character.valueOf('A'), Character.valueOf('S'), Character.valueOf('X'), Character.valueOf('D'), Character.valueOf('P'), Character.valueOf('C'), Character.valueOf('I'), Character.valueOf('Y'), Character.valueOf('V'), Character.valueOf('N'), Character.valueOf('0'), Character.valueOf('J'), Character.valueOf('E'), Character.valueOf('U'), Character.valueOf('6'), Character.valueOf('Z'), Character.valueOf('7'), Character.valueOf('R'), Character.valueOf('3'), Character.valueOf('B'), Character.valueOf('4'), Character.valueOf('H'), Character.valueOf('8'), Character.valueOf('O'), Character.valueOf('1'), Character.valueOf('W'), Character.valueOf('2'), Character.valueOf('9'), Character.valueOf('G'), Character.valueOf('5')};
    private static final List<String> RANDOM_LIST;
    private static final Long MAX_LIVE_ID;
    private static final int ZMByte = 2;
    private static final int numByte = 4;
    private static final int MAX_ZM_CODE_ID;
    private static final int MAX_NUM_CODE_ID;
    private static final int MAX_LOTTERY_CODE_ID;

    private LotteryCodeUtil() {
    }

    public static String encodeId2String(Long liveId, Long lotteryCodeId) {
        if (Objects.isNull(liveId) || Objects.isNull(lotteryCodeId)) {
            return null;
        }
        int cId = (int)(lotteryCodeId + liveId * 3L + 777L);
        if (lotteryCodeId > (long)MAX_LOTTERY_CODE_ID) {
            cId %= MAX_LOTTERY_CODE_ID;
        }
        int highNum = cId / MAX_NUM_CODE_ID;
        int lowNum = cId - highNum;
        int firstZMByte = highNum / 35;
        int secondZMByte = highNum % 35;
        Character firstChar = PLACEHOLDERS2[firstZMByte];
        Character secondChar = PLACEHOLDERS2[secondZMByte];
        Pair<String, String> lowDoubleChar = LotteryCodeUtil.getDoubleTwoCharByte(lowNum);
        return "" + firstChar + secondChar + (String)lowDoubleChar.getLeft() + (String)lowDoubleChar.getRight();
    }

    @NotNull
    private static Character getCharacter(List<Integer> byteList, int i) {
        return PLACEHOLDERS2[byteList.get(i)];
    }

    private static List<Integer> get35ByteList(int num) {
        if (num > MAX_LOTTERY_CODE_ID) {
            num %= MAX_LOTTERY_CODE_ID;
        }
        if (num == 0) {
            return Arrays.asList(0, 0, 0, 0);
        }
        ArrayList<Integer> chars = new ArrayList<Integer>();
        while (num > 35) {
            int larger = num / 35;
            chars.add(num - larger * 35);
            num = larger;
        }
        chars.add(num);
        int size = chars.size();
        if (size < 4) {
            for (int i = 0; i < 4 - size; ++i) {
                chars.add(0);
            }
        }
        return chars;
    }

    private static Pair<Character, Character> getTwoCharByLiveId(long liveId) {
        if (liveId > MAX_LIVE_ID) {
            liveId %= MAX_LIVE_ID.longValue();
        }
        int first = (int)liveId % 25;
        int last = (int)liveId / 25;
        return ImmutablePair.of((Object)PLACEHOLDERS[first], (Object)PLACEHOLDERS[last]);
    }

    private static Pair<String, String> getDoubleFourByteNumById(long lotteryCodeId) {
        if (lotteryCodeId > (long)MAX_LOTTERY_CODE_ID) {
            lotteryCodeId %= (long)MAX_LOTTERY_CODE_ID;
        }
        long lowFourByte = lotteryCodeId % 100000L;
        long highFourByte = lotteryCodeId / 10000L;
        Pair<String, String> highPair = LotteryCodeUtil.getDoubleTwoCharByte(highFourByte);
        Pair<String, String> lowPair = LotteryCodeUtil.getDoubleTwoCharByte(lowFourByte);
        return ImmutablePair.of((Object)((String)lowPair.getLeft() + (String)highPair.getRight()), (Object)((String)lowPair.getRight() + (String)highPair.getLeft()));
    }

    private static Pair<String, String> getDoubleTwoCharByte(long sourceNum) {
        if (sourceNum >= 10000L) {
            sourceNum %= 10000L;
        }
        long lowTwoByte = sourceNum % 100L;
        long highTwoByte = sourceNum / 100L;
        return ImmutablePair.of((Object)RANDOM_LIST.get((int)highTwoByte), (Object)RANDOM_LIST.get((int)lowTwoByte));
    }

    public static void main(String[] args) {
        System.out.println(LotteryCodeUtil.encodeId2String(1L, 39968L));
        System.out.println(LotteryCodeUtil.encodeId2String(1L, 35000L));
        long start = System.currentTimeMillis();
        HashMap<String, String> set = new HashMap<String, String>();
        for (long i = 0L; i < (long)MAX_LOTTERY_CODE_ID; ++i) {
            String old = set.put(LotteryCodeUtil.encodeId2String(0L, i), i + "");
            if (!Objects.nonNull(old)) continue;
            System.out.println(old + "==== " + i);
        }
        long cost = System.currentTimeMillis() - start;
        System.out.println("cost ======= " + cost + "\nsize=" + set.size());
    }

    static {
        MAX_LIVE_ID = 625L;
        MAX_ZM_CODE_ID = (int)Math.pow(35.0, 2.0);
        MAX_NUM_CODE_ID = (int)Math.pow(10.0, 4.0);
        MAX_LOTTERY_CODE_ID = MAX_ZM_CODE_ID * MAX_NUM_CODE_ID;
        String str = "99,30,74,75,35,17,67,43,01,62,03,66,84,79,26,39,97,52,25,87,55,60,05,44,90,70,63,06,13,11,28,83,72,82,32,37,64,14,10,57,40,00,45,81,96,42,09,19,04,23,18,12,16,47,02,91,80,36,76,29,48,24,56,33,92,78,50,41,07,31,34,21,89,86,08,73,22,69,51,98,27,88,68,94,71,38,85,49,15,93,54,77,61,53,95,46,20,58,59,65";
        String[] split = StringUtils.split((String)str, (String)",");
        RANDOM_LIST = Collections.unmodifiableList(Arrays.asList(split));
        str = null;
        Object var1_1 = null;
    }
}

