/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.enums.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.CustActionTypeEnum;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public enum CustFromSourceEnum {
    PUB_SELF_BUILD_FORM("01_01", CustActionTypeEnum.FORM, "\u6295\u653e\u5ba2\u6237-\u81ea\u5efa\u843d\u5730\u9875-\u8868\u5355"),
    PUB_SELF_BUILD_LIVE("01_01", CustActionTypeEnum.LAUNCH_LIVE, "\u6295\u653e\u5ba2\u6237-\u81ea\u5efa\u843d\u5730\u9875-\u76f4\u64ad"),
    PUB_FEIYU_CLUE_INVALID("01_02", CustActionTypeEnum.INVALID, "\u6295\u653e\u5ba2\u6237-\u98de\u9c7c\u843d\u5730\u9875-\u672a\u77e5\u884c\u4e3a"),
    PUB_FEIYU_CLUE_FORM("01_02", CustActionTypeEnum.FORM, "\u6295\u653e\u5ba2\u6237-\u98de\u9c7c\u843d\u5730\u9875-\u586b\u5355\u5ba2\u6237"),
    PUB_FEIYU_CLUE_CONSULT("01_02", CustActionTypeEnum.CONSULT, "\u6295\u653e\u5ba2\u6237-\u98de\u9c7c\u843d\u5730\u9875-\u54a8\u8be2\u83b7\u5ba2"),
    PUB_TENCENT_CLUE_INVALID("01_03", CustActionTypeEnum.INVALID, "\u6295\u653e\u5ba2\u6237-\u817e\u8baf\u843d\u5730\u9875-\u672a\u77e5\u884c\u4e3a"),
    PUB_TENCENT_CLUE_FORM("01_03", CustActionTypeEnum.FORM, "\u6295\u653e\u5ba2\u6237-\u817e\u8baf\u843d\u5730\u9875-\u586b\u5355\u5ba2\u6237"),
    PUB_TENCENT_CLUE_CONSULT("01_03", CustActionTypeEnum.CONSULT, "\u6295\u653e\u5ba2\u6237-\u817e\u8baf\u843d\u5730\u9875-\u54a8\u8be2\u83b7\u5ba2"),
    PUB_TENCENT_CLUE_PHONE("01_03", CustActionTypeEnum.INTELLIGENT_PHONE, "\u6295\u653e\u5ba2\u6237-\u817e\u8baf\u843d\u5730\u9875-\u667a\u80fd\u7535\u8bdd"),
    PUB_BAIDU_CLUE_INVALID("01_04", CustActionTypeEnum.INVALID, "\u6295\u653e\u5ba2\u6237-\u767e\u5ea6\u843d\u5730\u9875-\u672a\u77e5\u884c\u4e3a"),
    PUB_BAIDU_CLUE_FORM("01_04", CustActionTypeEnum.FORM, "\u6295\u653e\u5ba2\u6237-\u767e\u5ea6\u843d\u5730\u9875-\u586b\u5355\u5ba2\u6237"),
    PUB_HISTORY_IMPORT_FORM("01_05", CustActionTypeEnum.FORM, "\u6295\u653e\u5ba2\u6237-\u5386\u53f2\u8868\u5355\u5bfc\u5165-\u586b\u5355\u5ba2\u6237"),
    SELLER_OLD_CUST("02_01", CustActionTypeEnum.OLD, "\u9500\u552e\u81ea\u5efa-\u7f18\u6545\u5ba2\u6237-\u7f18\u6545\u5ba2\u6237"),
    SELLER_INTRODUCE_CUST("02_02", CustActionTypeEnum.INTRODUCE, "\u9500\u552e\u81ea\u5efa-\u8f6c\u4ecb\u7ecd\u5ba2\u6237-\u8f6c\u4ecb\u7ecd\u5ba2\u6237"),
    OTHER_ONLINE_MARKET_LIVE("03_01", CustActionTypeEnum.LIVE_FISSION, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0a\u8425\u9500\u88c2\u53d8-\u76f4\u64ad\u88c2\u53d8"),
    OTHER_ONLINE_MARKET_ASSIST("03_01", CustActionTypeEnum.ASSIST, "\u5176\u4ed6\u6765\u6e90-\u7ebf\u4e0a\u8425\u9500\u88c2\u53d8-\u52a9\u624b\u5ba2\u6237");

    private final String fromSource;
    private final CustActionTypeEnum actionType;
    private final String desc;
    private static Map<String, Map<String, CustFromSourceEnum>> SOURCE_MAP;
    private static final Set<String> CLUE_SOURCE_SET;
    private static final Set<String> SELLER_SOURCE_SET;

    public static String getStringByEnum(CustFromSourceEnum custFromSourceEnum) {
        return custFromSourceEnum.getFromSource() + "-" + custFromSourceEnum.getActionType().getType();
    }

    public static CustFromSourceEnum getEnumByString(String custFromSource) {
        if (StringUtils.isBlank((CharSequence)custFromSource)) {
            return null;
        }
        String[] params = custFromSource.split("-");
        if (params.length != 2) {
            return null;
        }
        if (!SOURCE_MAP.containsKey(params[0])) {
            return null;
        }
        Map<String, CustFromSourceEnum> actionTypeMap = SOURCE_MAP.get(params[0]);
        if (MapUtils.isEmpty(actionTypeMap) || !actionTypeMap.containsKey(params[1])) {
            return null;
        }
        return actionTypeMap.get(params[1]);
    }

    public static String getActionTypeByString(String custFromSource) {
        if (StringUtils.isBlank((CharSequence)custFromSource)) {
            return null;
        }
        CustFromSourceEnum enumByString = CustFromSourceEnum.getEnumByString(custFromSource);
        if (enumByString == null) {
            return null;
        }
        return enumByString.getActionType().getType();
    }

    public static boolean isCluePush(String custFromSource) {
        if (StringUtils.isBlank((CharSequence)custFromSource)) {
            return false;
        }
        return CLUE_SOURCE_SET.contains(custFromSource);
    }

    public static boolean isSellerBuild(String custFromSource) {
        if (StringUtils.isBlank((CharSequence)custFromSource)) {
            return false;
        }
        return SELLER_SOURCE_SET.contains(custFromSource);
    }

    public String getFromSource() {
        return this.fromSource;
    }

    public CustActionTypeEnum getActionType() {
        return this.actionType;
    }

    public String getDesc() {
        return this.desc;
    }

    private CustFromSourceEnum(String fromSource, CustActionTypeEnum actionType, String desc) {
        this.fromSource = fromSource;
        this.actionType = actionType;
        this.desc = desc;
    }

    static {
        SOURCE_MAP = null;
        CLUE_SOURCE_SET = Sets.newHashSet((Iterable)Arrays.stream(CustFromSourceEnum.values()).filter(custFromSourceEnum -> {
            if ("01_02".equals(custFromSourceEnum.getFromSource())) {
                return true;
            }
            if ("01_03".equals(custFromSourceEnum.getFromSource())) {
                return true;
            }
            return "01_04".equals(custFromSourceEnum.getFromSource());
        }).map(CustFromSourceEnum::getStringByEnum).collect(Collectors.toSet()));
        SELLER_SOURCE_SET = Sets.newHashSet((Object[])new String[]{CustFromSourceEnum.getStringByEnum(SELLER_OLD_CUST), CustFromSourceEnum.getStringByEnum(SELLER_INTRODUCE_CUST)});
        Arrays.stream(CustFromSourceEnum.values()).forEach(sourceEnum -> {
            if (MapUtils.isEmpty(SOURCE_MAP)) {
                SOURCE_MAP = new HashMap<String, Map<String, CustFromSourceEnum>>();
            }
            Map actionTypeMap = SOURCE_MAP.computeIfAbsent(sourceEnum.getFromSource(), k -> new HashMap());
            actionTypeMap.put(sourceEnum.getActionType().getType(), sourceEnum);
        });
    }
}

