package cn.com.duiba.live.normal.service.api.remoteservice.common;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 新手引导
 * @author lizhi
 * @date 2020/4/8 8:32 PM
 */
@AdvancedFeignClient
public interface RemoteLiveNoviceGuideApiService {

    /**
     * 根据用户某类型引导次数
     * @param liveUsersId 直播用户ID
     * @param guideType 引导类型：1-领红包
     * @see cn.com.duiba.live.normal.service.api.enums.common.NoviceGuideTypeEnum
     * @return 引导次数
     */
    int countByUserIdAndType(Long liveUsersId, Integer guideType);

    /**
     * 保存引导，若改类型引导已经存在，则直接返回0
     * 并发情况可能会保存多条
     * @param liveUsersId 直播用户ID
     * @param guideType 引导类型：1-领红包
     * @see cn.com.duiba.live.normal.service.api.enums.common.NoviceGuideTypeEnum
     * @return 执行结果
     */
    int saveGuide(Long liveUsersId, Integer guideType);
}
