package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 二段式客户邀约基础信息表
 * @author kjj mybatis generator 
 * @date 2022-08-03
 */
@Data
public class OtoCustInvitationDto implements Serializable {
     
    private static final long serialVersionUID = 16595050154328578L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 面访地点（见面场景配置ID）
     */
    private Long interviewConfId;

    /**
     * 客户面访承诺时间
     */
    private Date interviewTime;

    /**
     * 本次面访客户总人数
     */
    private Integer custNum;

    /**
     * 是否就餐 0否 1是
     */
    private Byte haveMealFlag;

    /**
     * 是否接送 0否 1是
     */
    private Byte pickTakeFlag;

    /**
     * 接送地址
     */
    private String pickTakeAddress;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 客户ID
     */
    private Long custId;

    /**
     * 邀约组销售ID
     */
    private Long inviteSellerId;

    /**
     * 客户是否已确认行程 1:待确认 2:已确认 3:已改期
     */
    private Byte inviteStatus;

    /**
     * 分配状态 1待分配 2已分配 3超时未分配
     */
    private Byte assignStatus;

    /**
     * 是否约到一面 0否 1是
     */
    private Byte firstInterviewFlag;
}