package cn.com.duiba.live.normal.service.api.dto.oto.cust;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 客户邀约记录表
 * @author kjj mybatis generator 
 * @date 2022-08-03
 */
@Data
public class OtoCustInvitationRecordDto implements Serializable {
     
    private static final long serialVersionUID = 16595050564207743L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 面访地点（见面场景配置ID）
     */
    private Long interviewConfId;

    /**
     * 客户面访承诺时间
     */
    private Date interviewTime;

    /**
     * 本次面访客户总人数
     */
    private Integer custNum;

    /**
     * 是否就餐 0否 1是
     */
    private Byte haveMealFlag;

    /**
     * 是否接送 0否 1是
     */
    private Byte pickTakeFlag;

    /**
     * 接送地址
     */
    private String pickTakeAddress;

    /**
     * 客户ID
     */
    private Long custId;

    /**
     * 邀约组销售ID
     */
    private Long inviteSellerId;

    /**
     * 带看组销售ID
     */
    private Long takeLookSellerId;

    /**
     * 专家对应的销售ID
     */
    private Long expertSellerId;

    /**
     * 分配状态 1待分配 2已分配 3超时未分配
     */
    private Byte assignStatus;

    /**
     * 客户是否已确认行程 1:待分配待确认 2:待分配已确认 3:待分配已鸽 4已分配预期到场 5已分配已到场 6已分配已鸽 7超期未分配
     */
    private Byte inviteStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否是最新的一条记录 0否 1是
     */
    private Byte newestFlag;

    /**
     * 此条数据的事件来源，枚举维护
     */
    private String eventType;

    /**
     * 是否约到一面 0否 1是
     */
    private Byte firstInterviewFlag;
}