package cn.com.duiba.live.normal.service.api.remoteservice.chinalife;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.chinalife.ChinaLifeUserRelatedDto;

import java.util.List;

/**
 * 中国人寿用户关联
 * @author 吴文哲
 * @date 2021/3/16 5:53 下午
 **/
@AdvancedFeignClient
public interface RemoteChinaLifeUserRelatedApiService {

    /**
     * 根据直播间Id + 中国人寿直播用户id 查询对应关系表
     * @param liveId 直播间id
     * @param liveUserId 中国人寿直播用户id
     * @return 中国人寿用户关联记录
     */
    ChinaLifeUserRelatedDto findByLiveIdAndLiveUserId(Long liveId, Long liveUserId);

    /**
     * 根据直播间Id + 客集集直播用户id 查询对应关系表
     * @param liveId 直播间id
     * @param liveUserId 中国人寿直播用户id
     * @return 中国人寿用户关联记录
     */
    ChinaLifeUserRelatedDto findByLiveIdAndKjjLiveUserId(Long liveId, Long liveUserId);

    /**
     * 批量新增或者更新
     * @param list 用户关联
     * @param chinaLifeLiveUserId 国寿直播用户id
     */
    void batchInsertOrUpdate(List<ChinaLifeUserRelatedDto> list, Long chinaLifeLiveUserId);
}
