package cn.com.duiba.live.normal.service.api.remoteservice.company;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.company.LiveCompanyVideoLikeRecordDto;

import java.util.Map;
import java.util.Set;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-09-24 18:00
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyVideoLikeRecordApiService {

    /**
     * 根据访客id和视频id查询点赞记录
     * @param liveVisitorId 访客id
     * @param videoId 视频id
     * @return 点赞记录
     */
    LiveCompanyVideoLikeRecordDto findByVisitorIdAndVideoId(Long liveVisitorId, Long videoId);

    /**
     * 查询访客点赞状态
     * @param liveVisitorId 访客直播用户id
     * @param videoIds 视频id集合
     * @return key：视频id value：点赞状态
     */
    Map<Long, Integer> getVisitorState(Long liveVisitorId, Set<Long> videoIds);

    /**
     * 新增
     * @param dto 直播公司精彩视频点赞记录
     * @return 执行结果
     */
    int insert(LiveCompanyVideoLikeRecordDto dto);

    /**
     * 根据视频id和访客id更新状态（唯一索引）
     * @param id 视频id
     * @param likeState 新状态
     * @return 执行结果
     */
    int updateState(Long id, Integer likeState);

}
