package cn.com.duiba.live.normal.service.api.remoteservice.pub.form;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.pub.form.PubFormRecordDetailDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2021/09/29 16:20
 * @description 公域流量 - 表单测试记录详情 RPC 接口
 */
@AdvancedFeignClient
public interface RemotePubFormRecordDetailApiService {

    /**
     * 写入测试记录详情
     *
     * @param dto 测试记录详情
     * @return 执行结果
     */
    int insert(PubFormRecordDetailDto dto);
    
    /**
     * 批量写入测试记录详情
     *
     * @param list 测试记录详情列表
     * @return 执行结果
     */
    int batchInsert(List<PubFormRecordDetailDto> list);

    /**
     * 查询提交详情记录
     *
     * @param recordIds 记录Id列表
     * @return 记录详情列表
     */
    List<PubFormRecordDetailDto> listByRecordId(List<Long> recordIds);

}
