package cn.com.duiba.live.normal.service.api.param.oto.cust;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import java.util.Date;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户邀约记录表
 * @author kjj mybatis generator 
 * @date 2022-08-04
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class OtoCustInvitationRecordSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 16595761519652762L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 面访地点（见面场景配置ID）
     */
    private Long interviewConfId;

    /**
     * 客户面访承诺时间
     */
    private Date interviewTime;

    /**
     * 本次面访客户总人数
     */
    private Integer custNum;

    /**
     * 是否就餐 0否 1是
     */
    private Integer haveMealFlag;

    /**
     * 是否接送 0否 1是
     */
    private Integer pickTakeFlag;

    /**
     * 接送地址
     */
    private String pickTakeAddress;

    /**
     * 客户ID
     */
    private Long custId;

    /**
     * 邀约组销售ID
     */
    private Long inviteSellerId;

    /**
     * 带看组销售ID
     */
    private Long takeLookSellerId;

    /**
     * 专家对应的销售ID
     */
    private Long expertSellerId;

    /**
     * 分配状态 1待分配 2已分配 3超时未分配
     */
    private Integer assignStatus;

    /**
     * 客户是否已确认行程 1:待分配待确认 2:待分配已确认 3:待分配已鸽 4已分配预期到场 5已分配已到场 6已分配已鸽 7超期未分配
     */
    private Integer inviteStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否是最新的一条记录 0否 1是
     */
    private Integer newestFlag;

    /**
     * 此条数据的事件来源，枚举维护
     * @see cn.com.duiba.live.normal.service.api.enums.oto.InvitationEventTypeEnum
     */
    private String eventType;

    /**
     * 是否约到一面 0否 1是
     */
    private Integer firstInterviewFlag;

    /**
     * 一面还是二面 1一面 2二面
     */
    private Integer firstTwoInviteStatus;

    /**
     * 查询条件 承诺开始时间
     */
    private Date startTime;
    /**
     * 查询条件 承诺结束时间
     */
    private Date endTime;
}