package cn.com.duiba.live.normal.service.api.enums.common;

import java.util.HashMap;
import java.util.Map;

/**
 * 新手引导类型枚举
 * @author lizhi
 * @date 2020/4/8 8:34 PM
 */
public enum NoviceGuideTypeEnum {
    LIVE_RED_PACKET(1, "领红包引导"),
    ;
    private Integer code;
    private String desc;

    NoviceGuideTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, NoviceGuideTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(NoviceGuideTypeEnum tmp : values()){
            ENUM_MAP.put(tmp.getCode(), tmp);
        }
    }

    public static NoviceGuideTypeEnum getByCode(Integer code) {
        return ENUM_MAP.get(code);
    }

}
