package cn.com.duiba.live.normal.service.api.remoteservice.oto.log;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.log.CustCallLogDto;
import cn.com.duiba.live.normal.service.api.param.oto.log.OtoLogSearchParam;

import java.util.Date;
import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-13 14:33
 */
@AdvancedFeignClient
public interface RemoteOtoCustCallLogService {

    /**
     * 获取最近正向拨号通话成功的通话记录
     * @param custId 客户id
     * @param otoSid 销售id
     * @return 通话记录
     */
    CustCallLogDto latestTakeSuccessLog(Long custId, Long otoSid);

    /**
     * 根据客户id和销售id以及时间查询日志（时间逆序）
     * @param param 查询参数
     * @return 日志列表
     */
    List<CustCallLogDto> listByCustIdAndTime(OtoLogSearchParam param);

    /**
     * 根据日志id判断有没有下一条
     * @param param 查询参数
     * @return 是否有下一条
     */
    boolean hasNext(OtoLogSearchParam param);

    /**
     * 保存客户通话日志
     * @param custCallLogDto 客户通话日志
     * @return 保存结果
     */
    Long save(CustCallLogDto custCallLogDto);

    /**
     * 筛选通话记录小于指定时间的客户
     *
     * @param custIds 客户id
     * @param endDate 时间
     * @return 客户id
     */
    List<Long> searchLtCallTime(Long sellerId, List<Long> custIds, Date endDate);

    /**
     * 批量修复数据
     * @param callLogList 日志数据
     * @return 修复结果
     */
    boolean batchFix(List<CustCallLogDto> callLogList);

    /**
     * 根据客户id和销售id查询销售外呼记录
     * @param custIds 客户id
     * @param sellerId 销售id
     * @return 日志列表
     */
    List<CustCallLogDto> listSellerCallByCustIdAndSid(List<Long> custIds,Long sellerId);
}
