package cn.com.duiba.live.normal.service.api.dto.oto.log;

import lombok.Data;

import java.io.Serializable;

/**
 * 客户价值日志表
 * @author kjj mybatis generator 
 * @date 2022-02-15
 */
@Data
public class CustValueLogDto implements Serializable {
     
    private static final long serialVersionUID = 16449099993069922L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 日志场景 1管理后台重新分配 2系统自动回收
     * @see cn.com.duiba.live.normal.service.api.enums.oto.log.CustValueLogSceneEnum
     */
    private Integer logScene;

    /**
     * 客户价值
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustValueEnum
     */
    private Integer custValue;

    /**
     * 客户权重 1:A 2:B 3:C
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.follow.OtoCustFollowWeightEnum
     */
    private Integer followWeight;

    /**
     * 销售评价
     */
    private Integer commentType;
}