package cn.com.duiba.live.normal.service.api.util;

import cn.com.duiba.live.normal.service.api.param.common.ApiPage;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.List;

/**
 * Created with duiba.
 * User: zhouzhou
 * Date: 2020/3/31 0031 Time: 10:44
 * <p>
 * Description: 兑吧专属的分页转换小工具
 */
public class PageUtils {

    /**
     * 把一个Page转换成另一page
     * @param sourcePage
     * @param clazz
     * @param <T>
     * @return
     */
    public static  <T extends Serializable> ApiPage<T> convertPage(ApiPage<?> sourcePage, Class<T> clazz) {
        ApiPage<T> page = new ApiPage<>();
        BeanUtils.copy(sourcePage, page);
        List<?> list = sourcePage.getList();
        if (CollectionUtils.isEmpty(list)) {
            page.setList(Lists.newArrayList());
        }else{
            List<T> targetList = BeanUtils.copyList(list, clazz);
            page.setList(targetList);
        }
        return page;

    }


}