package cn.com.duiba.live.normal.service.api.dto.help;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播-通用助力表
 *
 * @author kjj mybatis generator
 * @date 2021-05-20
 */
@Data
public class LiveCommonHelpDto implements Serializable {

    private static final long serialVersionUID = 1621501082344517L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 分享者直播用户ID
     */
    private Long sharerId;

    /**
     * 助力者直播用户ID
     */
    private Long helperId;

    /**
     * 红包、宝箱等配置ID
     */
    private Long confId;

    /**
     * 分享类型，1-常规，2-答题有奖，3-抽奖，4-普通红包，5-手气王，6-猜数字，7-裂变宝箱
     * @see cn.com.duiba.live.normal.service.api.enums.help.LiveHelpShareTypeEnum
     */
    private Integer shareType;

}