package cn.com.duiba.live.normal.service.api.enums.oto;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 销售角色类型枚举
 *
 * @author ZhangJun
 * @date 2022/1/7 5:35 下午
 */
@Getter
@AllArgsConstructor
public enum OtoSellerRoleTypeEnum {

    /**
     * 普通销售
     */
    COMMON(1, "普通销售"),

    /**
     * 销售管理员
     */
    ADMIN(2, "销售管理员"),

    /**
     * 总监
     */
    DIRECTOR(3, "总监"),

    /**
     * 管理员，可配置销售任务
     */
    MANAGER(4, "管理员"),
    ;

    private Integer roleType;
    private String desc;
}
