/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.normal.service.api.enums.oto.seller;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SellerRoleEnum {
    SYSTEM(0, "\u7cfb\u7edf\u7ba1\u7406\u5458"),
    DIRECTOR(1, "\u603b\u76d1"),
    OFFICE_STAFF(2, "\u5185\u52e4"),
    EXPERT(3, "\u4e13\u5bb6"),
    INVITE(4, "\u9080\u7ea6"),
    SELLER(5, "\u9500\u552e");

    private static final Map<Integer, String> TYPE_MAP;
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return TYPE_MAP.get(code);
    }

    public static SellerRoleEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return Stream.of(SellerRoleEnum.values()).filter(sellerRoleEnum -> sellerRoleEnum.getCode().equals(code)).findFirst().orElse(null);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private SellerRoleEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(SellerRoleEnum.values()).collect(Collectors.toMap(SellerRoleEnum::getCode, SellerRoleEnum::getDesc, (v1, v2) -> v1)));
    }
}

