package cn.com.duiba.live.normal.service.api.enums.oto;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * OTO-分配角色类型
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum AssignRoleTypeEnum {

    INVITE(1, "邀约人"),
    SALLER(2, "销售"),
    EXPERT(3, "专家")
    ;

    private Integer code;

    private String desc;

    private static final Map<Integer, String> TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(AssignRoleTypeEnum::getCode, AssignRoleTypeEnum::getDesc, (v1, v2)->v1)));


    public static String getDescByCode(Integer code){
        if (code == null) {
            return "";
        }
        return TYPE_MAP.get(code);
    }

    public static AssignRoleTypeEnum getByCode(Integer code){
        if (code == null) {
            return null;
        }
        return Stream.of(AssignRoleTypeEnum.values()).filter(assignRoleTypeEnum -> assignRoleTypeEnum.getCode().equals(code)).findFirst().orElse(null);
    }
}
