package cn.com.duiba.live.normal.service.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.company.CompanyVideoSortDto;
import cn.com.duiba.live.normal.service.api.dto.company.LiveCompanyVideoDto;
import cn.com.duiba.live.normal.service.api.param.company.LiveCompanyVideoSearchParam;

import java.util.List;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-09-24 17:38
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyVideoApiService {

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播公司精彩视频集合
     */
    List<LiveCompanyVideoDto> selectPage(LiveCompanyVideoSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveCompanyVideoSearchParam param);

    /**
     * 查询第二高的排序值，如果没有第二条数据返回初始值
     * @param companyId 公司id
     * @return 排序值
     */
    Integer selectSecondSort(Long companyId);

    /**
     * 获取排序最高的视频信息
     * @param companyId 公司id
     * @return 视频信息
     */
    LiveCompanyVideoDto selectTopOne(Long companyId);

    /**
     * 查询上一条的排序信息
     * @param companyId 公司id
     * @param sort 当前排序
     * @return 上一条的排序信息
     */
    CompanyVideoSortDto selectUpOne(Long companyId, Integer sort);

    /**
     * 查询下一条的排序信息
     * @param companyId 公司id
     * @param sort 当前排序
     * @return 下一条的排序信息
     */
    CompanyVideoSortDto selectDownOne(Long companyId, Integer sort);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播公司精彩视频
     */
    LiveCompanyVideoDto selectById(Long id);

    /**
     * 新增
     * @param dto 直播公司精彩视频
     * @return 执行结果
     */
    Long insert(LiveCompanyVideoDto dto);

    /**
     * 修改
     * @param dto 直播公司精彩视频
     * @return 执行结果
     */
    int update(LiveCompanyVideoDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 置顶
     * @param id 视频主键id
     * @return 处理结果
     */
    boolean top(Long id);

    /**
     * 取消置顶
     * @param id 视频主键id
     * @return 处理结果
     */
    boolean cancelTop(Long id);

    /**
     * 上移
     * @param id 视频主键id
     * @return 处理结果
     */
    boolean up(Long id);

    /**
     * 下移
     * @param id 视频主键id
     * @return 处理结果
     */
    boolean down(Long id);
}
