package cn.com.duiba.live.normal.service.api.remoteservice.interaction;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.interaction.LiveSubscribeDto;
import cn.com.duiba.live.normal.service.api.param.interaction.LiveSubscribeSearchParam;

import java.util.List;
import java.util.Map;

/**
 * @author zhanghuifeng
 * date 2020/4/4-2:56 下午
 */
@AdvancedFeignClient
public interface RemoteLiveSubscribeApiService {

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveSubscribeSearchParam param);

    /**
     * 根据条件查询
     * @param param
     * @return
     */
    List<LiveSubscribeDto> selectList(LiveSubscribeSearchParam param);

    /**
     * 新增关注记录
     * @param dto 用户ID
     * @return 执行结果
     */
    int insert(LiveSubscribeDto dto);

    /**
     * 查询直播用户ID对应关注次数
     * @param companyId 公司ID
     * @param liveUserIdList 直播用户ID集合
     * @return key：直播用户ID，value：关注次数
     */
    Map<Long, Long> getUserSubscribeCount(Long companyId, List<Long> liveUserIdList);
}
