package cn.com.duiba.live.normal.service.api.remoteservice.kuidi100;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.kuaidi100.ExpressCompanyDto;
import cn.com.duiba.live.normal.service.api.dto.kuaidi100.QueryTrackRespDto;
import cn.com.duiba.live.normal.service.api.param.kuaidi100.TrackQueryParam;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteKuidi100Service {

    /**
     * 查询物流信息
     */
    QueryTrackRespDto queryTrack(TrackQueryParam queryParam);

    /**
     * 获取所有已支持的快递公司
     */
    List<ExpressCompanyDto> getExpressCompanyList();

    /**
     * 获取快递公司编码：公司名称Map
     * 建议客户端缓存
     */
    Map<String, String> getExpressCompanyNumNameMap();

    /**
     * 获取快递公司名称：公司编码Map
     * 建议客户端缓存
     */
    Map<String, String> getExpressCompanyNameNumMap();
}
