package cn.com.duiba.live.normal.service.api.remoteservice.oto.company.ref;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.company.ref.CompanyCustomerRefDto;
import cn.com.duiba.live.normal.service.api.dto.oto.company.ref.CompanyFormRefDto;
import cn.com.duiba.live.normal.service.api.param.oto.company.ref.CompanyCustomerRefSearchParam;
import cn.com.duiba.live.normal.service.api.param.oto.company.ref.CompanyFormRefSearchParam;

import java.util.List;

/**
 * @author liuyj
 * @date 2022/6/27 13:36
 */
@AdvancedFeignClient
public interface RemoteCompanyFormRefService {
    /**
     * 根据表单id删除原有客户和产品组关系
     * @param formId 表单id
     */
    boolean deleteByFormId(Long formId);

    /**
     * 批量新增
     * @param params 参数
     * @return 结果
     */
    boolean batchSave(List<CompanyFormRefSearchParam> params);

    /**
     * 查询
     * @param param 参数
     * @return 结果集
     */
    List<CompanyFormRefDto> list(CompanyFormRefSearchParam param);
}
