package cn.com.duiba.live.normal.service.api.remoteservice.oto.config;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.config.OtoLeadsConfigDto;

import java.util.Map;

/**
 * OTO-相关配置
 *
 * @author ZhangJun
 * @date 2022/2/17 14:51
 */
@AdvancedFeignClient
public interface RemoteOtoConfigService {

    /**
     * 获取OTO-leads相关配置
     *
     * @return 配置详情
     */
    OtoLeadsConfigDto leadsConfig();

    /**
     * 获取每个销售的客户系数认领上限
     * @return 客户系数认领上限
     */
    Integer custCoefficientLimit();

    /**
     * 本地客户，行为对应的系数
     * @return 本地客户行为对应的系数
     */
    Map<String, Integer> getInnerActionTypeMap();

    /**
     * 本地客户，行为对应的系数
     * @return 本地客户行为对应的系数
     */
    Map<String, Integer> getInnerCustSourceMap();

    /**
     * 外地客户XX天被确认认领
     * @return XX天被确认认领
     */
    Integer outCustRemainDays();

}
