package cn.com.duiba.live.normal.service.api.remoteservice.oto.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.cust.CustVisitRecordDto;
import cn.com.duiba.live.normal.service.api.param.oto.cust.visit.CustFeedbackVisitSaveParam;
import cn.com.duiba.live.normal.service.api.param.oto.cust.visit.CustOrderVisitSaveParam;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-10 13:47
 */
@AdvancedFeignClient
public interface RemoteOtoCustVisitRecordService {

    /**
     * 保存预约拜访记录
     * @param param 拜访记录
     * @return 保存结果
     */
    boolean orderVisit(CustOrderVisitSaveParam param);

    /**
     * 保存拜访反馈记录
     * @param param 拜访记录
     * @return 保存结果
     */
    boolean feedbackVisit(CustFeedbackVisitSaveParam param);

    /**
     * 超过预约时间没有提交反馈的客户id
     * @param otoSid 销售id
     * @return 客户id
     */
    List<Long> listNotFeedbackCustIds(Long otoSid);

    /**
     * 获取最近的一条见面记录
     * @param otoSid 销售id
     * @param custId 客户id
     * @return 统计见面次数
     */
    CustVisitRecordDto findLatest(Long otoSid, Long custId);

    /**
     * 统计参观次数
     * @param otoSid 销售id
     * @param custId 客户id
     * @return 统计参观次数
     */
    long countBySidAndCustId(Long otoSid, Long custId);
}
