package cn.com.duiba.live.normal.service.api.enums.pub.form.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 公域引流-客户管理追加微信枚举
 *
 * @author xiaocong
 * @date 2021/11/17 7:42 下午
 */
@AllArgsConstructor
@Getter
public enum PubFormCustomerAppendWeChatEnum {

    /**
     * 否
     */
    UN_ADD(0, "否"),

    /**
     * 是
     */
    ADD(1, "是");

    /**
     * code
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String description;


    public static final Map<Integer, String> APPEND_WE_CHAT_MAP;

    static {
        Map<Integer, String> map = Arrays.stream(values()).collect(Collectors.toMap(PubFormCustomerAppendWeChatEnum::getCode, PubFormCustomerAppendWeChatEnum::getDescription));
        APPEND_WE_CHAT_MAP = Collections.unmodifiableMap(map);
    }
}
