package cn.com.duiba.live.normal.service.api.remoteservice.oto.company.ref;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.company.ref.CompanyCustomerRefDto;
import cn.com.duiba.live.normal.service.api.dto.oto.company.ref.CompanyLaunchAccountRefDto;
import cn.com.duiba.live.normal.service.api.param.oto.company.ref.CompanyCustomerRefSearchParam;
import cn.com.duiba.live.normal.service.api.param.oto.company.ref.CompanyLaunchAccountRefSearchParam;

import java.util.List;

/**
 * @author liuyj
 * @date 2022/6/27 13:36
 */
@AdvancedFeignClient
public interface RemoteCompanyCustomerRefService {
    /**
     * 根据客户ID删除原有客户和产品组关系
     * @param customerId 客户id
     */
    boolean deleteByCustomerId(Long customerId);

    /**
     * 批量新增
     * @param params 参数
     * @return 结果
     */
    boolean batchSave(List<CompanyCustomerRefSearchParam> params);

    /**
     * 查询
     * @param param 参数
     * @return 结果集
     */
    List<CompanyCustomerRefDto> list(CompanyCustomerRefSearchParam param);
}
