package cn.com.duiba.live.normal.service.api.dto.oto.config;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * OTO-leads相关配置
 *
 * @author ZhangJun
 * @date 2022/2/17 14:53
 */
@Data
public class OtoLeadsConfigDto implements Serializable {

    private static final long serialVersionUID = 2137264239247729823L;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 销售总客户数限制
     */
    private Integer totalCustLimit;

    /**
     * 销售每天分配客户数限制
     */
    private Integer dayAssignLimit;

    /**
     * 销售惩罚机制触发条件1：销售名下价值为N且未加星标的用户数>condition1
     * 销售惩罚机制触发条件2：存在「condition2」位价值为N的用户从第一通电话后，已经存在「condition3」天
     */
    private Integer sellerPunishCondition1;
    private Integer sellerPunishCondition2;
    private Integer sellerPunishCondition3;

    /**
     * 每天客户资源池的开放认领时间
     * 值为当天00:00:00-「认领时间」的秒数
     */
    private List<Long> custPoolOpenTime;

    /**
     * 客户资源池每次开放的时长，秒
     */
    private Long custPoolOpenDuration;

    /**
     * 在资源池开放后按销售等级分类展示客户时长，秒
     */
    private Integer custShowCritical;

    /**
     * 销售的工作时间
     * 值为当天00:00:00-「上、下班时间」的秒数
     * 7:00、18:30
     */
    private List<Long> sellerWorkTime;

    /**
     * 客户投放池等待认领的时长，秒
     * 30分钟
     */
    private Long custPoolAwaitTime;
}
