package cn.com.duiba.live.normal.service.api.enums.live.blackList;

import lombok.Getter;

/**
 * 黑名单来源类型枚举
 * @author 吴文哲
 * @date 2020-09-27 10:51
 **/
@Getter
public enum SourceTypeEnum {

    LIVE_VISITOR(1,"直播访客"),
    LIVE_AGENT(2,"直播代理人"),
    LIVE_PRE_PHONE_NUM(3,"直播预设黑名单手机"),
    LIVE_PRE_PHONE_NUM_LOGIN(4,"直播预设黑名单手机用户登陆")
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    SourceTypeEnum(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

}
