package cn.com.duiba.live.normal.service.api.enums.pub.form;


import java.util.HashMap;
import java.util.Map;

public enum PubFormBookingStatusEnum {

    TO_BE_VISITED(0, "待参观"),

    VISITED(1, "已参观"),

    ;
    private Integer value;
    private String text;

    PubFormBookingStatusEnum(Integer value, String text) {
        this.value = value;
        this.text = text;
    }

    private static final Map<Integer, PubFormBookingStatusEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PubFormBookingStatusEnum flagEnum : values()){
            ENUM_MAP.put(flagEnum.getValue(), flagEnum);
        }
    }

    public Integer getValue() {
        return value;
    }

    public String getText() {
        return text;
    }
}
