package cn.com.duiba.live.normal.service.api.enums.oto.seller;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * OTO-成员角色类型
 *
 * @author xiaotian
 */
@Getter
@AllArgsConstructor
public enum SellerRoleEnum {

    SYSTEM(1, "系统管理员"),
    DIRECTOR(2, "总监"),
    OFFICE_STAFF(3, "内勤"),
    EXPERT(4, "专家"),
    INVITE(5, "邀约"),
    SELLER(6, "销售");

    private static final Map<Integer, String> TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SellerRoleEnum::getCode, SellerRoleEnum::getDesc, (v1, v2) -> v1)));
    private Integer code;
    private String desc;

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return "";
        }
        return TYPE_MAP.get(code);
    }

    public static SellerRoleEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return Stream.of(SellerRoleEnum.values()).filter(sellerRoleEnum -> sellerRoleEnum.getCode().equals(code)).findFirst().orElse(null);
    }
}
