package cn.com.duiba.live.normal.service.api.param.oto.cust;

import cn.com.duiba.live.normal.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 19:47
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class OtoCustSearchConditionParam extends PageQuery {

    private static final long serialVersionUID = -2022243761711238739L;

    /**
     * 排序类型
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.OtoCustSortTypeEnum
     */
    private String sortType;

    /**
     * 客户价值
     *
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustValueEnum
     */
    private List<Integer> custValues;

    /**
     * 是否星标客户
     * 0=否,1=是
     */
    private Integer custStar;

    /**
     * 客户姓名
     */
    private String custName;

    /**
     * 客户id列表
     */
    private List<Long> custIdList;

    /**
     * 客户来源
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.CustSourceEnum
     */
    private List<Integer> custSources;

    /**
     * 行为类型，用，隔开
     */
    private List<String> custActionTypeList;

    /**
     * 客户地区
     */
    private List<String> custAreas;

}
