package cn.com.duiba.live.normal.service.api.param.oto.cust;

import cn.com.duiba.live.normal.service.api.enums.oto.cust.CustGenderEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-12 13:40
 */
@Data
public class OtoCustomerEditParam implements Serializable {

    private static final long serialVersionUID = -380981159017959838L;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 客户姓名
     */
    private String custName;

    /**
     * 省市区
     */
    private String custArea;

    /**
     * 备注
     */
    private String custDescription;

    /**
     * 加微信状态
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustWxStatusEnum
     */
    private Integer addWxStatus;

    /**
     * 参观进度
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustVisitProgressEnum
     */
    private Integer visitProgress;

    /**
     * 核心决策人
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustCoreMakerEnum
     */
    private String coreMaker;

    /**
     * 客户出生年份
     */
    private String custBirthYear;

    /**
     * 为谁考虑
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustForWhoEnum
     */
    private List<Integer> forWho;

    /**
     * 入住人出生年份
     */
    private Integer roomerBirthYear;

    /**
     * 入住人所在城市
     */
    private String roomerCity;

    /**
     * 考虑原因
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustReasonEnum
     */
    private Integer considerReason;

    /**
     * 保费付费压力
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustPressureEnum
     */
    private Integer payPressure;

    /**
     * 退休金
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustRetireMoneyEnum
     */
    private Integer retireMoney;

    /**
     * 参观机构
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustVisitOrgEnum
     */
    private List<Integer> visitOrg;

    /**
     * 资金情况
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustMoneyEnum
     */
    private Integer hasMoney;

    /**
     * 房产情况
     */
    private Integer hasHouse;

    /**
     * 家人态度
     * @see cn.com.duiba.live.normal.service.api.enums.oto.cust.ext.OtoCustFamilyAttitudeEnum
     */
    private Integer familyAttitude;

    /**
     * 理念是否认同
     */
    private Integer ideaAgree;

    /**
     * 客户地址
     */
    private String custAddress;

    /**
     * 客户性别
     * @see CustGenderEnum
     */
    private Integer custGender;

    /**
     * 专家备注
     */
    private String expertRemark;
}
