package cn.com.duiba.live.normal.service.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Set;

@AdvancedFeignClient
public interface RemoteLiveUserBookGoodsApiService {


    /**
     * 预定商品
     * @param liveId 直播ID 用于将用户预定数据在redis中使用liveId 分开存储
     * @param liveUserId 用户ID
     * @param confId 配置ID
     */
    boolean bookGoods(Long liveId , Long liveUserId,Long confId);

    /**
     * 查询用户预约了的商品列表
     * @param liveId 直播ID
     * @param liveUserId 用户ID
     * @return 预约列表
     */
    Set<Long> bookedGoodsList(Long liveId , Long liveUserId);
}
