package cn.com.duiba.live.normal.service.api.enums.oto;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public enum ReturnBackTypeEnum {

    INSIDE(1, "内情回退邀约组"),
    ;

    private Integer code;

    private String desc;

    ReturnBackTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ReturnBackTypeEnum::getCode, ReturnBackTypeEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据类型获取描述
     */
    public static String getDescCode(Integer code){
        if (code == null) {
            return null;
        }
        return ALL_MAP.get(code);
    }
}
