package cn.com.duiba.live.normal.service.api.remoteservice.oto.audit;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.audit.OtoAuditContentDto;
import cn.com.duiba.live.normal.service.api.param.oto.audit.OtoAuditContentBatchSearchParam;
import cn.com.duiba.live.normal.service.api.param.oto.audit.OtoAuditContentSearchParam;
import cn.com.duiba.live.normal.service.api.param.oto.audit.OtoAuditSearchParam;

import java.util.List;

/**
 * @author liuyj
 * @date 2022/5/31 13:57
 */
@AdvancedFeignClient
public interface RemoteAuditContentService {
    /**
     * 保存/提交入职信息
     * @param param 保存/提交 参数
     */
    void save(OtoAuditContentSearchParam param);

    /**
     * 编辑后保存入职信息
     * @param param 编辑 参数
     */
    void update(OtoAuditContentSearchParam param);

    /**
     * 查询审核内容记录
     * @param bizId
     * @return
     */
    OtoAuditContentDto queryByBizId(Long bizId);

    /**
     * 查询审核内容记录
     * @param param 查询对象
     * @return 审核内容
     */
    OtoAuditContentDto submitDetail(OtoAuditContentSearchParam param);

    /**
     * 查询（可支持分页和排序）
     * @param param 查询对象
     * @return 列表
     */
    List<OtoAuditContentDto> list(OtoAuditContentBatchSearchParam param);
}
