package cn.com.duiba.live.normal.service.api.remoteservice.oto.product;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.oto.product.OtoProductDto;
import cn.com.duiba.live.normal.service.api.dto.oto.product.OtoProductSimpleDTO;
import cn.com.duiba.live.normal.service.api.param.oto.product.ProductSearchParam;

import java.util.List;

/**
 * @author MeiChang
 * @Description
 */
@AdvancedFeignClient
public interface RemoteOtoProductService {
    /**
     * 新增、编辑产品
     *
     * @param productDto
     * @return
     */
    Boolean save(OtoProductDto productDto);

    /**
     * 产品详情
     *
     * @param id
     * @return
     */
    OtoProductDto detail(Long id);

    /**
     * 上、下架产品
     *
     * @param id
     * @return
     */
    Boolean updateStatus(Long id);

    /**
     * 多条件分页查询产品列表
     *
     * @param param
     * @return
     */
    List<OtoProductDto> list(ProductSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(ProductSearchParam param);

    /**
     * 校验参数
     * @param productDto
     * @return
     */
    Boolean checkProduct(OtoProductDto productDto);

    /**
     * 根据销售获取所在公司管理产品列表，不分页
     * @param sellerId 销售ID
     * @param custId 客户ID
     * @return
     */
    List<OtoProductDto> listBySellerId(Long sellerId, Long custId);

    /**
     * 查询传参的业务类型的产品，产品=上架中
     * @param types 业务类型
     * @return 产品详情集合
     */
    List<OtoProductSimpleDTO> listByBusinessTypes(List<Integer> types);

    /**
     * 查询所有产品
     * @return 产品集合
     */
    List<OtoProductSimpleDTO> listAll();
}
