package cn.com.duiba.live.statistics.service.api.dto.reward;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 直播奖品签收金额统计表
 * @author kjj mybatis generator 
 * @date 2021-03-18
 */
@Data
public class LiveRewardAmountStatsDto implements Serializable {
     
    private static final long serialVersionUID = 16160577710294218L;

    /**
     * 主键Id
     */
    private Long id;

    /**
     * 直播Id
     */
    private Long liveId;

    /**
     * 代理人Id
     */
    private Long agentId;

    /**
     * 统计类型：1-代理人得红包，2-代理人下访客得到红包
     * @see cn.com.duiba.live.statistics.service.api.enums.reward.LiveRewardStatTypeEnum
     */
    private Integer statType;

    /**
     * 代理人/代理人下访客得到的红包总金额
     */
    private Integer totalAmount;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}