package cn.com.duiba.live.statistics.service.api.enums.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 客户年龄枚举
 *
 * @author ZhangJun
 * @date 2021/7/2 5:10 下午
 */
@Getter
@AllArgsConstructor
public enum AgeEnum {

    /**
     * 其它
     */
    OTHER(null, "其它"),

    /**
     * 0-10周岁
     */
    ZERO(0, "0-10周岁"),

    /**
     * 11-20周岁
     */
    ONE(1, "11-20周岁"),

    /**
     * 21-30周岁
     */
    TWO(2, "21-30周岁"),

    /**
     * 31-40周岁
     */
    THREE(3, "31-40周岁"),

    /**
     * 41-50周岁
     */
    FOUR(4, "41-50周岁"),

    /**
     * 51-60周岁
     */
    FIVE(5, "51-60周岁"),

    /**
     * 61-70周岁
     */
    SIX(6, "61-70周岁"),

    /**
     * 71-80周岁
     */
    SEVEN(7, "71-80周岁"),

    /**
     * 81-90周岁
     */
    EIGHT(8, "81-90周岁"),

    /**
     * 91-100周岁
     */
    NINE(9, "91-100周岁"),

    /**
     * 101-110周岁
     */
    TEN(10, "101-110周岁"),

    /**
     * 111-120周岁
     */
    ELEVEN(11, "111-120周岁"),

    /**
     * 121-130周岁
     */
    TWELVE(12, "121-130周岁"),

    /**
     * 131-140周岁
     */
    THIRTEEN(13, "131-140周岁"),
    ;


    /**
     * 年龄段
     */
    private final Integer ageGroup;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, AgeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (AgeEnum item : values()) {
            ENUM_MAP.put(item.getAgeGroup(), item);
        }
    }

    /**
     * 是否存在该枚举字段
     */
    public static boolean existEnum(Integer ageGroup) {
        return Objects.nonNull(ENUM_MAP.get(ageGroup));
    }

}
