package cn.com.duiba.live.statistics.service.api.enums.potential;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 跟进机会类型枚举
 *
 * @author ZhangJun
 * @date 2021/7/22 2:37 下午
 */
@Getter
@AllArgsConstructor
public enum ChanceTypeEnum {

    /**
     * 咨询专属顾问
     */
    CONSULTANT(1, "咨询"),

    /**
     * 权益-图文
     */
    RESOURCE_MATERIAL(2, "图文"),

    /**
     * 权益-链接
     */
    RESOURCE_LINK(3, "链接"),

    /**
     * 权益-表单
     */
    RESOURCE_FORM(4, "表单"),

    /**
     * 权益-免费领
     */
    RESOURCE_FREE(5, "免费领"),

    /**
     * 权益-小游戏
     */
    RESOURCE_GAME(6, "小游戏"),
    ;

    private final Integer code;

    private final String desc;
}
