package cn.com.duiba.live.statistics.service.api.enums.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 客户首次邀请类型标记
 *
 * @author ZhangJun
 * @date 2021/7/23 10:43 上午
 */
@Getter
@AllArgsConstructor
public enum FirstInvitedFlagEnum {

    /**
     * 首次邀请类型为间接邀请
     */
    INDIRECT(0, "间接邀请"),

    /**
     * 首次邀请类型为直接邀请
     */
    DIRECT(1, "直接邀请"),
    ;

    private final Integer code;
    private final String desc;
}
