package cn.com.duiba.live.statistics.service.api.enums.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 是否有子女枚举
 *
 * @author ZhangJun
 * @date 2021/7/22 2:13 下午
 */
@Getter
@AllArgsConstructor
public enum HasChildrenEnum {

    /**
     * 未知
     */
    UN_KNOW(null, "未知"),

    /**
     * 没有子女
     */
    NO_CHILDREN(0, "没有子女"),

    /**
     * 有子女
     */
    HAS_CHILDREN(1, "有子女"),
    ;

    private final Integer code;

    private final String desc;

}
