package cn.com.duiba.live.statistics.service.api.enums.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 年收入枚举
 *
 * @author ZhangJun
 * @date 2021/7/2 5:15 下午
 */
@Getter
@AllArgsConstructor
public enum IncomeEnum {

    /**
     * 未知
     */
    UN_KNOW(null, "未知"),

    /**
     * 0-10万
     */
    ZERO(0, "0-10万"),

    /**
     * 11-20万
     */
    ONE(1, "11-20万"),

    /**
     * 21-30万
     */
    TWO(2, "21-30万"),

    /**
     * 31-40万
     */
    THREE(3, "31-40万"),

    /**
     * 41-50万
     */
    FOUR(4, "41-50万"),

    /**
     * 51-60万
     */
    FIVE(5, "51-60万"),

    /**
     * 61-70万
     */
    SIX(6, "61-70万"),

    /**
     * 71-80万
     */
    SEVEN(7, "71-80万"),

    /**
     * 81-90万
     */
    EIGHT(8, "81-90万"),

    /**
     * 91-100万
     */
    NINE(9, "91-100万"),

    /**
     * 100万以上
     */
    TEN(10, "100万以上"),
    ;


    /**
     * 收入阶段
     */
    private final Integer incomeGroup;

    /**
     * 描述
     */
    private final String desc;


    private static final Map<Integer, IncomeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (IncomeEnum item : values()) {
            ENUM_MAP.put(item.getIncomeGroup(), item);
        }
    }

    /**
     * 是否存在该枚举字段
     */
    public static boolean existEnum(Integer incomeGroup) {
        return Objects.nonNull(ENUM_MAP.get(incomeGroup));
    }

}
