package cn.com.duiba.live.statistics.service.api.param.user;

import cn.com.duiba.live.statistics.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 访客直播线索得分详情
 * @author kjj mybatis generator 
 * @date 2020-07-24
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveUserScoreStatSearchParam extends PageQuery {
     
    private static final long serialVersionUID = 15955744473166544L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 访客ID
     */
    private Long visitorId;

    /**
     * 访客的代理人ID
     */
    private Long agentId;

    /**
     * 观看时长得分
     */
    private Integer watchScore;

    /**
     * 评论得分
     */
    private Integer speakScore;

    /**
     * 订阅得分
     */
    private Integer subscribeScore;

    /**
     * 关注得分
     */
    private Integer appointScore;

    /**
     * 分享得分
     */
    private Integer shareScore;

    /**
     * 提问得分
     */
    private Integer questionScore;

    /**
     * 投票得分
     */
    private Integer choiceQuestionScore;

    /**
     * 抽奖得分
     */
    private Integer lotteryScore;

    /**
     * 免费领得分
     */
    private Integer freeLotteryScore;

    /**
     * 领取资料得分
     */
    private Integer resourceScore;

    /**
     * 咨询得分
     */
    private Integer adviceScore;

    /**
     * 总分
     */
    private Integer totalScore;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}