package cn.com.duiba.live.statistics.service.api.remoteservice.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.customer.AgentCustomerExtDto;
import cn.com.duiba.live.statistics.service.api.dto.customer.AgentCustomerInfoDto;
import cn.com.duiba.live.statistics.service.api.param.customer.AgentCustomerListParam;

import java.util.List;

/**
 * 客户维度，代理人客户基础信息
 *
 * @author ZhangJun
 * @date 2021/6/30 3:34 下午
 */
@AdvancedFeignClient
public interface RemoteAgentCustomerApiService {

    /**
     * 根据代理人id + 客户id集合查询客户列表
     *
     * @param agentId     代理人id
     * @param customerIds 客户id集合
     * @return 客户列表
     */
    List<AgentCustomerInfoDto> getListByCustomerIds(Long agentId, List<Long> customerIds);

    /**
     * 根据代理人id + 客户id集合 + 客户类型查询客户列表
     *
     * @param agentId      代理人id
     * @param customerIds  客户id集合
     * @param customerType 客户类型
     * @return 客户列表
     */
    List<AgentCustomerInfoDto> getListByCustomerIdsAndType(Long agentId, List<Long> customerIds, Integer customerType);

    /**
     * 根据指定条件分页查询代理人客户列表
     *
     * @param param 查询条件
     * @return 客户列表
     */
    List<AgentCustomerInfoDto> getListByCondition(AgentCustomerListParam param);

    /**
     * 获取代理人客户基础信息
     *
     * @param agentId    代理人id
     * @param customerId 客户id
     * @return 客户基础信息
     */
    AgentCustomerInfoDto getAgentCustomerInfo(Long agentId, Long customerId);

    /**
     * 获取代理人客户扩展信息
     *
     * @param agentId    代理人id
     * @param customerId 客户id
     * @return 客户扩展信息
     */
    List<AgentCustomerExtDto> getAgentCustomerExt(Long agentId, Long customerId);


    /**
     * 查询客户指定扩展字段
     *
     * @param agentId  代理人id
     * @param customerId  客户id
     * @param infoName 扩展字段名
     * @return 扩展字段值
     */
    AgentCustomerExtDto getAgentCustomerExtByInfoName(Long agentId, Long customerId, Integer infoName);

    /**
     * 新增客户扩展信息
     *
     * @param agentId    代理人id
     * @param customerId 客户id
     * @param infoName   扩展字段名
     * @param infoValue  扩展字段值
     * @return 新增结果
     */
    boolean saveCustomerExt(Long agentId, Long customerId, Integer infoName, String infoValue);

    /**
     * 更新客户扩展信息
     *
     * @param agentId    代理人id
     * @param customerId 客户id
     * @param infoName   扩展字段名
     * @param infoValue  扩展字段值
     * @return 更新结果
     */
    boolean updateCustomerExt(Long agentId, Long customerId, Integer infoName, String infoValue);

}
